package net.babelstar.common.view;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.KeyEvent;

import net.babelstar.cmsv6demo.R;


public class WaitDialog extends Dialog {
	private WaitCancelListener mCancelListener;

	public WaitDialog(Context context, WaitCancelListener listener) {
		super(context, android.R.style.Theme_Translucent_NoTitleBar);
		mCancelListener = listener;
	}
	
	public WaitDialog(Context context, WaitCancelListener listener, Boolean fullScreen) {
		super(context, android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);
		mCancelListener = listener;
	}

	protected final void onCreate(Bundle paramBundle) {
		super.onCreate(paramBundle);
		setContentView(R.layout.wait_dialog);
	}

	public boolean onKeyDown(int keyCode, KeyEvent paramKeyEvent) {
		if (keyCode == KeyEvent.KEYCODE_BACK) {
			if (mCancelListener.onWaitCancel()) {
				return true;
			}
		}
		return super.onKeyDown(keyCode, paramKeyEvent);
	}

	public abstract interface WaitCancelListener {
		/*
		 * 返回true表示不需要关闭，返回false表示需要关闭
		 */
		public abstract boolean onWaitCancel();
	}
}

