package net.babelstar.common.play;

import android.content.Context;
import android.os.Environment;
import android.util.Log;

import com.babelstar.gviewer.NetClient;


public class PBDownLoad extends UpdateThread{

	//protected static final Logger logger = LoggerFactory.getLogger();
	private boolean isLoading = false;	//是否加载成功
	private boolean isBeginDownLoad = false;	//是否开始播放
	private Object lockHandle = new Object();	//RealHandle的锁
	private long mPlayHandle = 0;	//下载对象
	private int mPlayRate = 0;		//实时预览的码率
	//private String mFileInfo = null;
	private long mInvalidateTime = 0;			//刷新时间
	private long mUpdateTime = 0;
	private String mDevIdno;
	private String mVelIdno;
	private String mTime;
	private int mFileType;
	private Context mContext = null;
	private UpdateDLProcessThread mUpdateDLProcess = null;
	private String mLanIp;
	private Integer mLanPort;
	private String DOWBLOAD_DIRECTORY = "gStorage/pbdownload/";
	private String mCacheDownLoadPath= "";
	private String mFileDownLoadPath = "";
//	private String mDownLoadPath = Environment.getExternalStorageDirectory().getPath() + "/" + DOWBLOAD_DIRECTORY;
//	private String mFileDownLoadPath = Environment.getExternalStorageDirectory().getPath() + "/" + DOWBLOAD_DIRECTORY;
	private String mFillFullPath = "";
	private int mPBDownLoadTime = 0;		//下载时间
	private int mBegMinSecond = 0;
	private int mEndMinSecond = 0;
	private PBDownLoadListener mDownLoadListener = null;
	public PBDownLoad(Context context) {
		mContext = context;

//		if (Build.VERSION.SDK_INT > 28) {
//			mCacheDownLoadPath = mContext.getExternalFilesDir("Cache") + "/pbdownload/";
//			mFileDownLoadPath = mContext.getExternalFilesDir("gStorage") + "/pbdownload/";
//		} else {
//			mCacheDownLoadPath = Environment.getExternalStorageDirectory().getPath() + "/Cache/" + DOWBLOAD_DIRECTORY;
//			mFileDownLoadPath = Environment.getExternalStorageDirectory().getPath() + "/" + DOWBLOAD_DIRECTORY;
//		}

		mCacheDownLoadPath = mContext.getExternalFilesDir("Cache") + "/pbdownload/";
//		mFileDownLoadPath = mContext.getExternalFilesDir("gStorage") + "/pbdownload/";
		mFileDownLoadPath = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_MOVIES) + "/gStorage/pbdownload";

	}

	public String getFillFullPath(){
		return mFillFullPath;
	}
	public void setDownLoadListener(PBDownLoadListener downLoadListener) {
		mDownLoadListener = downLoadListener;
	}

	public void setPBDownLoadDevIdno(String devIdno) {
		if(devIdno.length() > 32){
			devIdno = "123456789";
		}
		mDevIdno = devIdno;

	}

	public void setLanInfo(String lanIp, Integer lanPort) {
		this.mLanIp = lanIp;
		this.mLanPort = lanPort;
	}

	public void setBegAndEndMin(int nBegMinSecond, int nEndMinSecond) {
		this.mBegMinSecond = nBegMinSecond;
		this.mEndMinSecond = nEndMinSecond;
	}

	public void setPBDownLoadPath(String VelIdno, String date, String time, int fileType) {
		if(VelIdno.length() > 32){
			VelIdno = "123456789";
		}
		if(date.isEmpty()){
			date = "1900-01-01";
		}
		mVelIdno = VelIdno;
		mTime = time;
		mFileType = fileType;
//		mFileDownLoadPath += mVelIdno + "(" + mDevIdno + ")" + "/" + date;
	}
	public void setPBDownLoadPathEx(String path, String filePath,String VelIdno, String time, int fileType) {
		mVelIdno = VelIdno;
		mTime = time;
		mFileType = fileType;
		mCacheDownLoadPath = path;
		mFileDownLoadPath = filePath;
	}

	public boolean StartPBDownLoad(byte[] fileInfo, int nFileInfoLength, int channel) {
    	//先停止
		StopPBDownLoad();

    	boolean ret = false;
    	//mFileInfo = fileInfo;
    	mUpdateTime = System.currentTimeMillis();
    	//启动视频预览
    	synchronized (lockHandle) {
    		//需要用CacheDir 不然小米手机不能下载
//			String tmpPath = mContext.getCacheDir().getPath() + "/";
			String tmpPath = mContext.getExternalCacheDir().getPath() + "/";
			Log.d("cmsv7", "StartPBDownLoad tmpPath: " + tmpPath);
			//mDownLoadPath
			mPlayHandle = NetClient.PBOpenPlayBackEx(tmpPath);
			if(mLanIp != null){
				NetClient.PBSetRealServer(mPlayHandle, mLanIp, mLanPort, "");
			}
//			NetClient.PBStartDownload(mPlayHandle, mFileDownLoadPath, mVelIdno);
			NetClient.PBStartDownloadEx(mPlayHandle, mFileDownLoadPath,
					mVelIdno, mTime, channel, mFileType);
			NetClient.PBStartPlaybackEx(mPlayHandle, fileInfo, nFileInfoLength,
					channel, mBegMinSecond, mEndMinSecond, 0, mDevIdno);
			if (mPlayHandle != 0) {
				isLoading = true;
				isBeginDownLoad = false;
				ret = true;
			}
    	}
    	if (ret) {
			startDownLoadThread();
    	}
    	return ret;
    }
    
    public boolean StopPBDownLoad() {
    	boolean ret = false;
    	synchronized (lockHandle) {
	    	if (mPlayHandle != 0) {
				byte[] fileFullPath = new byte[256];
				java.util.Arrays.fill(fileFullPath, (byte)0);
				int nRet = NetClient.PBEndDownloadWithFilePath(mPlayHandle, fileFullPath, 256);
				if(nRet == NetClient.NET_SUCCESS){
					int i = 0;
					for (i = 0; i < fileFullPath.length; ++ i) {
						if (fileFullPath[i] == 0) {
							break;
						}
					}
					byte[] temp = new byte[i];
					System.arraycopy(fileFullPath, 0, temp, 0, i);
					mFillFullPath = new String(temp);
				}
				NetClient.PBStopPlayback(mPlayHandle);
				NetClient.PBClosePlayback(mPlayHandle);
				mPlayHandle = 0;
				isLoading = false;
				mPlayRate = 0;
				ret = true;
				stopDownLoadThread();
			}
    	}
    	return ret;
    }

	/*
	 * 开始下载线程
	 */
	private void startDownLoadThread() {
		if (mUpdateDLProcess == null) {
			mUpdateDLProcess = new UpdateDLProcessThread();
			mUpdateDLProcess.start();
		}
	}

	/*
	 * 停止下载线程
	 */
	private void stopDownLoadThread() {
		if (mUpdateDLProcess != null) {
			Thread dummy = mUpdateDLProcess;
			mUpdateDLProcess.setExit(true);
			mUpdateDLProcess = null;
			dummy.interrupt();
		}
	}

	/*
	 * 暂停
	 */
	private void pauseDownLoad(boolean isPause) {
		if (mUpdateDLProcess != null) {
			mUpdateDLProcess.setPause(isPause);
		}
	}

	/*
	 * 下载状态检测线程
	 */
	private class UpdateDLProcessThread extends Thread{
		private boolean isExit = false;
		private boolean isPause = false;
		private int nNum = 0;
		public void setExit(boolean isExit) {
			this.isExit = isExit;
		}

		public void setPause(boolean isPause) {
			this.isPause = isPause;
		}

		public void run()   {

			while (!isExit) {
				boolean isDownFinished = NetClient.PBIsDownFinished(mPlayHandle) == NetClient.NET_SUCCESS ? true : false;
				try {

					if (!isPause) {
//						updateView();
						if(!isBeginDownLoad){
							isBeginDownLoad = true;
							mDownLoadListener.onBeginPlay();

						}
						mPBDownLoadTime = NetClient.PBGetDownTime(mPlayHandle);
						if(mPBDownLoadTime == 0){
							nNum ++;
							mDownLoadListener.onUpdatePlay(mPBDownLoadTime);
							//1分钟内没有获取数据就停止下载(针对网络链接慢，设置1分钟)
							if(nNum == 30){
								// -1 失败
								mDownLoadListener.onEndPlay(-1);
							}

						}else{
							mDownLoadListener.onUpdatePlay(mPBDownLoadTime);
						}

						Thread.sleep(2000);
					} else {
						Thread.sleep(3000);
					}
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				if(isDownFinished){
					mDownLoadListener.onEndPlay(0);
				}
			}
			this.isExit = true;
			nNum = 0;
		}
	}

	public static interface PBDownLoadListener {
		/*
		 * 开始时行播放
		 */
		public abstract void onBeginPlay();

		/*
		 * 更新播放
		 */
		public abstract void onUpdatePlay(int nDownSecond);

		/*
		 * 播放结束
		 */
		public abstract void onEndPlay(int nDownStatus);

	}
}
