package net.babelstar.common.play;

import android.os.Handler;
import android.os.Message;

import com.babelstar.gviewer.NetClient;

import net.babelstar.common.play.AudioPlay.AudioReader;

public class Monitor implements AudioReader {
	
	

	private MonitorListener mMonitorListener = null;
	private	long mMonitorHandle = 0;
	
	///private Object lockRecord = new Object();	//锁
	private AudioPlayThread mPlayThread = null;	//视频界面更新线程
//	private MyAudioRecord mAudioRecord = new MyAudioRecord();	//声音捕获对象
	private Object mLockAudioPlay = new Object();	//mAudioPlay的锁
	private AudioPlay mAudioPlay = new AudioPlay();
//	private boolean mIsAudioPlay = false;
	private boolean mIsAudioSounding = false;	//是否已经播放声音了
	public static final int MSG_Monitor_STOP = 1;
	private boolean mIsAudioPlay = false;
	public void setMonitorListener(MonitorListener listener) {
		mMonitorListener = listener;
	}
	
	public void sendStopMonitorMsg() {
		Message message = Message.obtain();
		message.what  = MSG_Monitor_STOP;
		mHandler.sendMessage(message);
	}
	
	// handler对象，用来接收消息~
    private Handler mHandler = new Handler() {
    	@Override
    	public void handleMessage(Message msg) {
    		//这个是发送过来的消
    		// 处理从子线程发送过来的消息
    		if (msg.what == MSG_Monitor_STOP) {
    			if (mMonitorListener != null) {
    				mMonitorListener.onStop();
    			}
    		}
    	};
    };
	
	/*
	 * 开始监听
	 */
	public boolean startMonitor(String devIdno, int nChannel) {
    	boolean ret = false;
		if (mMonitorHandle == 0) {
			mMonitorHandle = NetClient.MTOpenMonitor(devIdno, nChannel, 0);
			NetClient.MTStartMonitor(mMonitorHandle);	
			
			if (mMonitorHandle != 0) {
				startAudioPlayThread();
				playSound();
				ret = true;
//				if (startRecord()) {
//					ret = true;
//				} else {
//					stopTalkback();
//				}
			}
		}
		return ret;
	}
	
	/*
	 * 停止监听
	 */
	public boolean stopMonitor() {
		boolean ret = false;
    	if (mMonitorHandle != 0) {
    		stopSound();
    		//stopRecord();
			NetClient.MTStopMonitor(mMonitorHandle);
			NetClient.MTCloseMonitor(mMonitorHandle);
			mMonitorHandle = 0;
			ret = true;
		}
    	return ret;
	}
	
	/*
	 * 取得音频格式
	 */
	protected boolean getWavFormat() {
		int format[] = new int[4];
		if (NetClient.NET_SUCCESS == NetClient.MTGetWavFormat(mMonitorHandle, format)) {
			mAudioPlay.setWavFormat(format[0], format[1], format[2], format[3]);
		//	mAudioRecord.setFormat(1, 8000);		//aac 16k,24k会出问题
			return true;
		} else {
			return false;
		}
	}
	
	/*
	 * 开始声音播放
	 */
	public void playSound() {
		if (mMonitorHandle != 0) {
			synchronized (mLockAudioPlay) {
				mIsAudioPlay = true;
				mIsAudioSounding = false;
				initSound();
			}
		}
	}
	
	/*
	 * 停止声音播放
	 */
	public void stopSound() {
		synchronized (mLockAudioPlay){
			if (mAudioPlay != null) {
				stopAudioPlayThread();
				mAudioPlay.stopSound();
				mIsAudioPlay = false;
				mIsAudioSounding = false;
			}
		}
		
	}
	
	/*
	 * 停止声音
	 */
	public void initSound() {
		if (getWavFormat()) {
			mIsAudioSounding = true;
			mAudioPlay.playSound(Monitor.this);
			//mAudioRecord.startRecord();
		}
	}
	
	/*
	 * 返回获取到的大小
	 */
	public int onReadWavData(byte[] pWavBuf, int nWavLen){
		int nReadLen = NetClient.MTGetWavData(mMonitorHandle, pWavBuf, nWavLen);
		return nReadLen;
	}
	
	/*
	 * 开始声音播放线程
	 */
	private void startAudioPlayThread() {
		if (mPlayThread == null) {
			mPlayThread = new AudioPlayThread();
			mPlayThread.start();
		}
	}
	/*
	 * 停止声音播放线程
	 */
	private void stopAudioPlayThread() {
		if (mPlayThread != null) {
			Thread dummy = mPlayThread;
			mPlayThread.setExit(true);
			mPlayThread = null;
			dummy.interrupt();
		}
	}
	
	
	/*
     * 判断是否正在监听
     */
    public boolean isMonitor() {
    	boolean ret = false;
    	if (this.mMonitorHandle != 0) {
    		ret = true;
    	}
    	return ret;
    }
    
    public static interface MonitorListener {
		/*
		 * 停止监听，当终端已经和别的客户端处于对讲状态时，则会调用此接口
		 */
		public abstract void onStop();
    }
    
    private class AudioPlayThread extends Thread{
    	private boolean isExit = false;
		
		public void setExit(boolean isExit) {
			this.isExit = isExit;
		}
		
		public void run()   { 
			//boolean isBreak = false;
		
			while (!isExit) {
				try {
					Thread.sleep(1000);

					int nReadLen = 0;										
					synchronized (mLockAudioPlay) {
			     		if (mIsAudioPlay && !mIsAudioSounding) {
			     			initSound();
			     			//isBreak = mIsAudioSounding;
			     		}
			     	}
				} catch (InterruptedException e) {
					e.printStackTrace();
				} 
				//if (NetClient.MnGetStop(mMonitorHandle) == NetClient.NET_SUCCESS) {
				if(mIsAudioSounding && isExit){					
					break;
				}
			}
		this.isExit = true;

	}
    }
}
