package net.babelstar.common.http;

import com.google.code.microlog4android.Logger;
import com.google.code.microlog4android.LoggerFactory;

import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import okhttp3.ResponseBody;
//import com.alibaba.fastjson.JSONObject;

/**
 * Abstract Async Response Listener implementation
 * 
 * Subclass should implement at lease two methods.
 * 1. onSuccess() to handle the corresponding successful response object
 * 2. onFailure() to handle the exception if any
 * 
 * @author bright_zheng
 *
 */
public abstract class AbstractAsyncResponseListener implements AsyncResponseListener{
	public static final int RESPONSE_TYPE_STRING = 1;
	public static final int RESPONSE_TYPE_JSON_ARRAY = 2;
	public static final int RESPONSE_TYPE_JSON_OBJECT = 3;
	public static final int RESPONSE_TYPE_STREAM = 4;
	private static final Logger logger = LoggerFactory.getLogger();
	
	private int responseType;
	
	public AbstractAsyncResponseListener(){
		this.responseType = RESPONSE_TYPE_JSON_OBJECT; // default type
	}
	
	public AbstractAsyncResponseListener(int responseType){
		this.responseType = responseType;
	}

	public String convertEntity2String(HttpEntity response) {
		int nLength = (int) response.getContentLength();
		if (nLength <= 0) {
			nLength = 1024 * 1024;
		}

		String  strTemp= "";
		StringBuilder strBuild = new StringBuilder();
		try {
			InputStream inStream = response.getContent();
			BufferedReader bufferReader = new BufferedReader(new InputStreamReader(inStream), nLength);
			while ((strTemp = bufferReader.readLine()) != null) {
				strBuild.append(strTemp);
			}
		} catch(IOException e) {
			logger.trace("onResponseReceived IOException " + e.getMessage());
		}
		return strBuild.toString();
	}


	public void onResponseReceived(HttpEntity response, String respStr, ResponseBody responseBody1){
		try {
			switch(this.responseType){

		        case RESPONSE_TYPE_JSON_ARRAY:{
		        	String responseBody = EntityUtils.toString(response);	
		        	logger.trace("Return JSON String: " + responseBody);
		        	JSONArray json = null;
		        	if(responseBody!=null && responseBody.trim().length()>0){
		        		json = (JSONArray) new JSONTokener(responseBody).nextValue();
		        	}
		    		onSuccess(json);
		        	break;
		        }
		        case RESPONSE_TYPE_JSON_OBJECT:{

		        	JSONObject json = null;
		        	if (respStr != null) {
//		        		Log.d("fastJson", "OutputHolder Return JSON String JSONTokener Start:"
//								+ respStr);
						try{
							json = (JSONObject) new JSONTokener(respStr).nextValue();

					   	}catch(Exception e){
							logger.trace("onResponseReceived Exception " + e.getMessage());
							onFailure(e);
						}finally{


						}
					} else {
						String responseBody = convertEntity2String(response);
						if(responseBody!=null && responseBody.trim().length()>0){
							json = (JSONObject) new JSONTokener(responseBody).nextValue();
						}
					}
//					Log.d("fastJson", "OutputHolder Return JSON String end: "
//							+ json.toString());

					onSuccess(json);
		        	break;
		        }
		        case RESPONSE_TYPE_STREAM:{
		        	onSuccess(response.getContent());
		        	break;
		        }
		        default:{
		        	String responseBody = EntityUtils.toString(response);
		        	onSuccess(responseBody);
		        }         
			}
	    } catch(IOException e) {
	    	logger.trace("onResponseReceived IOException " + e.getMessage());
	    	onFailure(e);
	    } catch (JSONException e) {
	    	logger.trace("onResponseReceived JSONException " + e.getMessage());
	    	onFailure(e);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void onResponseReceived(Throwable response){
		onFailure(response);
	}

	
	protected void onSuccess(JSONArray response){}
	
	protected void onSuccess(JSONObject response) throws Exception {}
	
	protected void onSuccess(InputStream response){}
	
	protected void onSuccess(String response) {}

	protected void onFailure(Throwable e) {}
}
