package net.babelstar.cmsv6demo.okhttp;




/**
 * Created by harry on 2020/2/24.
 */


import okhttp3.MediaType;

public enum MediaTypes {

    /**
     * APPLICATION_JSON
     */
    APPLICATION_JSON(MediaType.parse("application/json")),
    /**
     * APPLICATION_JSON_UTF8
     */
    APPLICATION_JSON_UTF8(MediaType.parse("application/json;charset=UTF-8")),
    /**
     * APPLICATION_XML
     */
    APPLICATION_XML(MediaType.parse("application/xml")),
    /**
     * APPLICATION_XML_UTF8
     */
    APPLICATION_XML_UTF8(MediaType.parse("application/xml;charset=UTF-8")),


    APPLICATION_FORM_UTF8(MediaType.parse("application/x-www-form-urlencoded"));


    private MediaType mediaType;

    MediaTypes(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public MediaType getMediaType() {
        return mediaType;
    }
}