package net.babelstar.cmsv6demo.okhttp;




/**
 * Created by harry on 2020/2/24.
 */


import android.util.Log;

import com.alibaba.fastjson.JSON;

import net.babelstar.common.http.AsyncResponseListener;

import org.apache.commons.lang.StringUtils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpClientUtils {
    /**
     * 超时参数
     */
    private static final String TAG = "httpClient";
    private static final int CONNECT_TIME_OUT = 120;
    private static final int READ_TIME_OUT = 60;
    private static final int WRITE_TIME_OUT = 60;
    private static OkHttpClient HTTP_CLIENT;
    private static final int HTTP_CACHE_SIZE = 1024 * 1024 * 256;
    private static List<Cookie> l_cookie;
    private static final HashMap<String, List<Cookie>> cookieStore = new HashMap<>();
    static {
//        dispatcher.setMaxRequestsPerHost(10);
        if(HTTP_CLIENT == null){
            HTTP_CLIENT = new OkHttpClient.Builder()
                    //为构建者填充超时时间
                    .connectTimeout(CONNECT_TIME_OUT, TimeUnit.SECONDS)///连接超时
                    .readTimeout(READ_TIME_OUT, TimeUnit.SECONDS)
                    .writeTimeout(WRITE_TIME_OUT, TimeUnit.SECONDS)
                    //允许重定向
                    .followRedirects(true)//okhttp 4.**版本会导致低版本Android请求报错 java.lang.ExceptionInInitializerError 此处还需要优化下
                    .sslSocketFactory(createSSLSocketFactory(), new TrustAllManager())
                    .hostnameVerifier(new TrustAllHostnameVerifier())
                    .connectionPool(new ConnectionPool(300, 5, TimeUnit.MINUTES))
                    .connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS,
                            ConnectionSpec.CLEARTEXT))
                    .cookieJar(new CookieJar() {
                        @Override
                        public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                            cookieStore.put(url.host(), cookies);
                            l_cookie = cookies;
                        }

                        @Override
                        public List<Cookie> loadForRequest(HttpUrl url) {
                            List<Cookie> cookies = cookieStore.get(url.host());
                            if(cookies==null){
                                System.out.println("没加载到cookie");
                            }
                            return cookies != null ? cookies : new ArrayList<Cookie>();
                        }
                    })
                    .build();
        }


    }

    public static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");//SSL TLS
            sc.init(null, new TrustManager[]{new TrustAllManager()},
                    new SecureRandom());//
            sSLSocketFactory = sc.getSocketFactory();
        } catch (Exception ignored) {
        }
        return sSLSocketFactory;
    }

    public static class TrustAllManager implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType)
                throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType)
                throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[]{};
        }

    }

    public static class TrustAllHostnameVerifier implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    /**
     * json参数的同步get请求 返回对象
     *
     * @param url    请求URL
     * @param header 请求头
     * @param clazz  返回对象类型
     * @return 返回对象
     */
    public static <E> E doGetReturnJson(String url, Map<String, String> header, Class<E> clazz) {
        String result = doGet(url, header);
        if (StringUtils.isBlank(result)) {
            return null;
        }
        return JSON.parseObject(result, clazz);
    }

    /**
     * json参数的同步Post请求 返回对象
     *
     * @param url         请求URL
     * @param header      请求头
     * @param requestBody 请求报文
     * @param mediaType   请求类型
     * @param clazz       返回对象类型
     * @return 返回对象
     */
    public static <E> E doPostReturnJson(String url, Map<String, String> header, String requestBody,
                                         MediaTypes mediaType, Class<E> clazz) {
        String result = doPost(url, header, requestBody, mediaType);
        if (StringUtils.isBlank(result)) {
            return null;
        }
        return JSON.parseObject(result, clazz);
    }

    /**
     * json参数的同步Post请求
     *
     * @param url     请求url
     * @param jsonStr 请求json
     * @return return message
     */
    public static String doPostWithJson(String url, String jsonStr) {
        return doPost(url, null, jsonStr, MediaTypes.APPLICATION_JSON_UTF8);
    }

    /**
     * xml参数的同步Post请求
     *
     * @param url    请求url
     * @param xmlStr 请求xml
     * @return return message
     */
    public static String doPostWithXml(String url, String xmlStr) {
        return doPost(url, null, xmlStr, MediaTypes.APPLICATION_XML_UTF8);
    }

    public static String doPut(String url, Map<String, String> formMap) {
        return doPut(url, formMap, MediaTypes.APPLICATION_FORM_UTF8);
    }

    public static String doDelete(String url) {
        Request.Builder builder = new Request.Builder().delete().url(url);
        return execute(url, builder.build());
    }

    /**
     * 同步Get请求
     *
     * @param url    请求url
     * @param header 请求头参数
     * @return 返回报文
     */
    public static String doGet(String url, Map<String, String> header) {
        Request.Builder builder = new Request.Builder().get().url(url);
        if (!header.isEmpty()) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return execute(url, builder.build());
    }

    /**
     * 同步Get请求
     *
     * @param url 请求url
     * @return 返回报文
     */
    public static byte[] doGetReturnBytes(String url) {
        Request.Builder builder = new Request.Builder().get().url(url);
        return executeBytes(url, builder.build());
    }

    /**
     * 同步Get请求
     *
     * @param url 请求url
     * @return 返回报文
     */
    public static byte[] doGetReturnBytes(String url, Map<String, String> header) {
        Request.Builder builder = new Request.Builder().get().url(url);
        if (!header.isEmpty()) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return executeBytes(url, builder.build());
    }

    /**
     * 同步Get请求
     *
     * @param url 请求url
     * @return 返回响应体
     */
    public static Response doGet(String url) {
        Request.Builder builder = new Request.Builder().get().url(url);
       // log.info("执行请求[{}]", url);
        try {
            return HTTP_CLIENT.newCall(builder.build()).execute();
        } catch (IOException e) {
            throw new HttpClientException("执行请求[" + url + "]失败", e);
        }
    }

    /**
     * 同步Post请求
     *
     * @param url 请求url
     * @return 返回报文
     */
    public static byte[] doPostReturnBytes(String url) {
        Request.Builder builder = new Request.Builder().post(
                RequestBody.create(MediaTypes.APPLICATION_FORM_UTF8.getMediaType(), "")).url(url);
        return executeBytes(url, builder.build());
    }

    public static byte[] doPostReturnBytes(String url, String requestBody, MediaTypes mediaType) {
        RequestBody body = RequestBody.create(mediaType.getMediaType(), requestBody);
        Request.Builder builder = new Request.Builder()
                .post(body)
                .url(url);
        return executeBytes(url, builder.build());
    }

    /**
     * 同步Post请求
     *
     * @param url         请求url
     * @param header      请求头参数
     * @param requestBody 请求体参数
     * @param mediaType   请求类型
     * @return 返回报文
     */
    public static String doPost(String url, Map<String, String> header, String requestBody, MediaTypes mediaType) {
        RequestBody body = RequestBody.create(mediaType.getMediaType(), requestBody);
        return doPost(url, header, body);
    }

    public static String doPost(String url, Map<String, String> header, RequestBody requestBody) {
        Request.Builder builder = new Request.Builder()
                .post(requestBody)
                .url(url);
        if (!header.isEmpty()) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return execute(url, builder.build());
    }

    public static String doPut(String url, Map<String, String> formMap, MediaTypes mediaType) {
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        if (!formMap.isEmpty()) {
            for (Map.Entry<String, String> entry : formMap.entrySet()) {
                bodyBuilder.add(entry.getKey(), entry.getValue());
            }
        }

        Request.Builder builder = new Request.Builder()
                .put(bodyBuilder.build())
                .url(url);

        return execute(url, builder.build());
    }

    /**
     * 异步Get请求
     *
     * @param url      请求url
     * @param header   请求头参数
     * @param callBack 异步通知接口，调用方实现
     */
    public static void doAsyncGet(String url, Map<String, String> header, AsyncResponseListener callBack) {
        Request.Builder builder = new Request.Builder().get().url(url);
        if (header != null && !header.isEmpty()) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }

        asyncExecuteEx(callBack, builder.build());
    }

    /**
     * 异步Post请求
     *
     * @param url         请求url
     * @param header      请求头参数
     * @param requestBody 请求体参数
     * @param mediaType   请求类型
     * @param callBack    异步通知接口，调用方实现
     */
    public static void doAsyncPost(String url, Map<String, String> header, String requestBody, MediaTypes mediaType,
                                   AsyncResponseListener callBack) {
        Request.Builder builder = new Request.Builder()
                .post(RequestBody.create(mediaType.getMediaType(), requestBody))
                .url(url);
        if(header != null && !header.isEmpty()){
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        asyncExecuteEx(callBack, builder.build());
    }

    /**
     * 异步Post请求
     *
     * @param url         请求url
     * @param header      请求头参数
     * @param~~requestBody 请求体参数
     * @param callBack    异步通知接口，调用方实现
     */
    public static void doAsyncPostEx(String url, Map<String, String> header,
                                   AsyncResponseListener callBack, FormBody.Builder formbody) {
        if(formbody == null){
            return;
        }
        RequestBody body = formbody.build();
        Request.Builder builder = new Request.Builder()
                .post(body)
                .url(url);
        if(header != null && !header.isEmpty()){
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        asyncExecuteEx(callBack, builder.build());
    }

    public static String buildUrl(String url, Map<String, String> querys) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(url);
        if (null != querys) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : querys.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank(query.getKey()) && !StringUtils.isBlank(query.getValue())) {
                    sbQuery.append(query.getValue());
                }
                if (!StringUtils.isBlank(query.getKey())) {
                    sbQuery.append(query.getKey());
                    if (!StringUtils.isBlank(query.getValue())) {
                        sbQuery.append("=");
                        sbQuery.append(URLEncoder.encode(query.getValue(), "utf-8"));
                    }
                }
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append(sbQuery);
            }
        }

        return sbUrl.toString();
    }

    /**
     * 同步执行http请求
     *
     * @param url     请求url
     * @param request 请求request对象
     * @return String 返回报文
     */
    private static String execute(String url, Request request) {
       // log.info("执行请求[{}]", url);
        try (Response response = HTTP_CLIENT.newCall(request).execute()) {

            ResponseBody body = response.body();
            String responseBody = (body == null ? null : body.string());

            if (!response.isSuccessful()) {
               // log.error("执行请求[{}]失败, 响应码：{}, 响应体：{}", url, response.code(), responseBody);
                throw new HttpClientException("执行请求[" + url + "]失败");
            }
            return responseBody;
        } catch (IOException e) {
            throw new HttpClientException("执行请求[" + url + "]失败", e);
        }
    }
    private static StringBuilder convertEntity2StringBodyEx(ResponseBody response){
        int nLength = (int) response.contentLength();
//        Log.i(TAG, "length:" + nLength);
        if (nLength <= 0) {
            nLength = 1024 * 1024;
        }
//        StringBuilder strBuild = new StringBuilder();
        StringBuilder strBuildTmp = new StringBuilder();
        byte[] buffer = new byte[nLength];
        int len =0;
        int lenTotal = 0;
        try (InputStream inputStream = response.byteStream()){
            while ((len = inputStream.read(buffer)) != -1) {
                String str = new String(buffer,0,len, Charset.defaultCharset());
//                if(lenTotal < 1024 * 1024 * 4){
//                    strBuild.append(str);
//                }
                strBuildTmp.append(str);
                lenTotal += len;
                Log.i(TAG, "streamChat inputStream.read: " +len +"--lenTotal:" + lenTotal);

            }
        }catch (
                Exception e) {
            Log.i(TAG, "streamChat responseBody 3");
            e.printStackTrace();
        }
//        Log.i(TAG, "streamChat strBuild: " +strBuild.toString() +"--lenTotal:" + lenTotal);
        return strBuildTmp;
    }
    private static String convertEntity2StringBody(ResponseBody response) {

        int nLength = (int) response.contentLength();
        if (nLength <= 0) {
            nLength = 1024 * 1024;
        }

        String  strTemp = null;
        StringBuilder strBuild = new StringBuilder();
        try {
            InputStream inStream = response.byteStream();
            int i = 0;
//			logger.log(Level.INFO, "OutputHolder doHttp getContent nLength:" + nLength + ", url:" +url);
            BufferedReader bufferReader = new BufferedReader(new InputStreamReader(inStream), nLength);
            while ((strTemp = bufferReader.readLine()) != null) {
//				logger.log(Level.INFO, "OutputHolder doHttp new readLine url:" +url);
//                Log.i(TAG, "streamChat --i:" + i);
                strBuild.append(strTemp);
                i++;
//				logger.log(Level.INFO, "OutputHolder doHttp append url:" +url);
            }
        } catch(IOException e) {
            Log.i(TAG, "onResponseReceived IOException:" + e.getMessage());
//            log.info("onResponseReceived IOException " + e.getMessage());
        }
//		logger.log(Level.INFO, "OutputHolder doHttp 7 nlength:" + nLength +"url:" +url);
        return strBuild.toString();
    }
    /**
     * 异步执行http请求
     *
     * @param callBack 异步通知接口，调用方实现
     * @param request  请求request对象
     */
    private static void asyncExecuteEx(AsyncResponseListener callBack, final Request request) {
//        String url = request.url().toString();
//        Log.i(TAG, "执行请求[{}]" + url);
        HTTP_CLIENT.newCall(request).enqueue(new Callback() {

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onResponseReceived(e);
            }

            @Override
            public void onResponse(Call call, Response response){

                ResponseBody body = response.body();
//                ResponseBody bodyNet =  response.networkResponse().body();
//                ResponseBody bodyCatch = response.cacheResponse().body();
                try {

                    if (!response.isSuccessful()) {
                        //  log.error("执行请求[{}]失败, 响应码：{}, 响应体：{}", url, response.code(), responseBody);
                        callBack.onResponseReceived(null, "", body);
                        return;
                    }
//                    StringBuilder responseBodyEx = convertEntity2StringBodyEx(body);

                    String responseBody = "";
//                    Log.i(TAG, "length:" + body.contentLength());
                    if(body != null){
                        responseBody = convertEntity2StringBody(body);
                    }
//                    Log.i(TAG, "end length:" + body.contentLength());
//                    String responseBody = (body == null ? null : body.string());
                    // log.info("执行请求[{}]成功, 响应码：{}", url, response.code());
                    callBack.onResponseReceived(null, responseBody, body);
                }catch (Exception e){
                    callBack.onResponseReceived(e);
                }

            }
        });
    }

    /**
     * 异步执行http请求
     *
     * @param callBack 异步通知接口，调用方实现
     * @param request  请求request对象
     */
    private static void asyncExecute(ResultCallBack callBack, final Request request) {
        String url = request.url().toString();
        //log.info("执行请求[{}]", url);
        HTTP_CLIENT.newCall(request).enqueue(new Callback() {

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onRequestFailure(call.request().url().toString(), e);
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {

                ResponseBody body = response.body();
                String responseBody = (body == null ? null : body.string());

                if (!response.isSuccessful()) {
                  //  log.error("执行请求[{}]失败, 响应码：{}, 响应体：{}", url, response.code(), responseBody);
                    callBack.onResponseFailure(url, response.code(), responseBody);
                    return;
                }
               // log.info("执行请求[{}]成功, 响应码：{}", url, response.code());
                callBack.onSuccess(call.request().url().toString(), responseBody);
            }
        });
    }

    /**
     * 同步执行http请求
     *
     * @param url     请求url
     * @param request 请求request对象
     * @return byte[] 返回报文
     */
    private static byte[] executeBytes(String url, Request request) {
       // log.info("执行请求[{}]", url);
        try (Response response = HTTP_CLIENT.newCall(request).execute()) {

            ResponseBody body = response.body();
            byte[] bytes = (body == null ? null : body.bytes());

            if (!response.isSuccessful()) {
             //   log.error("执行请求[{}]失败, 响应码：{}", url, response.code());
                throw new HttpClientException("执行请求[" + url + "]失败");
            }
            return bytes;
        } catch (IOException e) {
            throw new HttpClientException("执行请求[" + url + "]失败", e);
        }
    }

}
