/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android.repository;

import android.util.Log;
import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.Logger;
import com.google.code.microlog4android.repository.CommonLoggerRepository;
import com.google.code.microlog4android.repository.LoggerNamesUtil;
import com.google.code.microlog4android.repository.LoggerRepository;
import com.google.code.microlog4android.repository.MicrologRepositoryNode;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public enum DefaultLoggerRepository implements LoggerRepository,
CommonLoggerRepository
{
    INSTANCE;

    private static final String TAG = "Microlog.DefaultLoggerRepository";
    private MicrologRepositoryNode rootNode;
    private Hashtable<String, MicrologRepositoryNode> leafNodeHashtable = new Hashtable(43);

    private DefaultLoggerRepository() {
        Logger rootLogger = new Logger("", this);
        rootLogger.setLevel(Level.DEBUG);
        this.rootNode = new MicrologRepositoryNode("", rootLogger);
    }

    @Override
    public Logger getRootLogger() {
        return this.rootNode.getLogger();
    }

    @Override
    public synchronized Logger getLogger(String name) {
        Logger logger;
        MicrologRepositoryNode node = this.leafNodeHashtable.get(name);
        if (node == null) {
            logger = new Logger(name, this);
            this.addLogger(logger);
        } else {
            logger = node.getLogger();
        }
        return logger;
    }

    void addLogger(Logger logger) {
        String[] pathComponents;
        String loggerName = logger.getName();
        MicrologRepositoryNode currentNode = this.rootNode;
        String[] stringArray = pathComponents = LoggerNamesUtil.getLoggerNameComponents(loggerName);
        int n = pathComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String pathComponent = stringArray[n2];
            MicrologRepositoryNode child = currentNode.getChildNode(pathComponent);
            if (child == null) {
                currentNode = this.createNewChildNode(pathComponent, currentNode);
            }
            ++n2;
        }
        if (pathComponents.length > 0) {
            String leafName = LoggerNamesUtil.getClassName(pathComponents);
            MicrologRepositoryNode leafNode = new MicrologRepositoryNode(leafName, logger, currentNode);
            currentNode.addChild(leafNode);
            this.leafNodeHashtable.put(loggerName, leafNode);
        }
    }

    @Override
    public void setLevel(String name, Level level) {
        MicrologRepositoryNode leafNode = this.leafNodeHashtable.get(name);
        if (leafNode != null) {
            leafNode.getLogger().setLevel(level);
        } else {
            String[] pathComponents;
            MicrologRepositoryNode currentNode = this.rootNode;
            String[] stringArray = pathComponents = LoggerNamesUtil.getLoggerNameComponents(name);
            int n = pathComponents.length;
            int n2 = 0;
            while (n2 < n) {
                String pathComponent = stringArray[n2];
                MicrologRepositoryNode child = currentNode.getChildNode(pathComponent);
                if (child == null) {
                    currentNode = this.createNewChildNode(pathComponent, currentNode);
                }
                ++n2;
            }
            if (currentNode != null) {
                currentNode.getLogger().setLevel(level);
            }
        }
    }

    private MicrologRepositoryNode createNewChildNode(String pathComponent, MicrologRepositoryNode currentNode) {
        MicrologRepositoryNode newChild = new MicrologRepositoryNode(pathComponent, currentNode);
        currentNode.addChild(newChild);
        return newChild;
    }

    @Override
    public Level getEffectiveLevel(String loggerName) {
        Level effectiveLevel = null;
        MicrologRepositoryNode currentNode = this.leafNodeHashtable.get(loggerName);
        while (effectiveLevel == null && currentNode != null) {
            effectiveLevel = currentNode.getLogger().getLevel();
            currentNode = currentNode.getParent();
        }
        return effectiveLevel;
    }

    @Override
    public boolean contains(String name) {
        return this.leafNodeHashtable.containsKey(name);
    }

    @Override
    public int numberOfLeafNodes() {
        return this.leafNodeHashtable.size();
    }

    @Override
    public void reset() {
        this.rootNode.resetLogger();
        this.leafNodeHashtable.clear();
    }

    @Override
    public void shutdown() {
        Enumeration<MicrologRepositoryNode> leafNodes = this.leafNodeHashtable.elements();
        while (leafNodes.hasMoreElements()) {
            MicrologRepositoryNode node = leafNodes.nextElement();
            Logger logger = node.getLogger();
            if (logger == null) continue;
            try {
                logger.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Failed to close logger " + logger.getName()));
            }
        }
    }
}

