/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android.format.command;

import android.util.Log;
import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.format.command.FormatCommandInterface;
import com.google.code.microlog4android.format.command.util.StringUtil;

public class CategoryFormatCommand
implements FormatCommandInterface {
    private static final String TAG = "Microlog.CategoryFormatCommand";
    public static final int FULL_CLASS_NAME_SPECIFIER = -1;
    public static final int DEFAULT_PRECISION_SPECIFIER = 1;
    private int precisionSpecifier = 1;

    @Override
    public String execute(String clientID, String name, long time, Level level, Object message, Throwable throwable) {
        String convertedData = "";
        if (name != null) {
            convertedData = this.precisionSpecifier == -1 ? name : StringUtil.extractPartialClassName(name, this.precisionSpecifier);
        }
        return convertedData;
    }

    @Override
    public void init(String initString) {
        try {
            this.precisionSpecifier = Integer.parseInt(initString);
            System.out.println("Precision specifier for %c is " + this.precisionSpecifier);
        }
        catch (NumberFormatException e) {
            Log.e((String)TAG, (String)("Failed to parse the specifier for the %c pattern " + e));
        }
    }

    public int getPrecisionSpecifier() {
        return this.precisionSpecifier;
    }

    public void setPrecisionSpecifier(int precisionSpecifier) {
        this.precisionSpecifier = precisionSpecifier;
    }
}

