/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android.config;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.util.Log;
import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.Logger;
import com.google.code.microlog4android.appender.Appender;
import com.google.code.microlog4android.appender.FileAppender;
import com.google.code.microlog4android.format.Formatter;
import com.google.code.microlog4android.format.PatternFormatter;
import com.google.code.microlog4android.repository.DefaultLoggerRepository;
import com.google.code.microlog4android.repository.LoggerRepository;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyConfigurator {
    private static final String TAG = "Microlog.PropertyConfiguration";
    public static String DEFAULT_PROPERTIES_FILENAME = "microlog.properties";
    public static final String ROOT_LOGGER_KEY = "microlog.rootLogger";
    public static final String MICROLOG_PREFIX = "microlog";
    public static final String LOGGER_PREFIX_KEY = "microlog.logger";
    public static final String FORMATTER_PREFIX_KEY = "microlog.formatter";
    public static final String PATTERN_LAYOUT_PREFIX_KEY = "microlog.formatter.PatternFormatter.pattern";
    public static final String APPENDER_PREFIX_KEY = "microlog.appender";
    public static final String FILE_APPENDER_FILE_NAME_KEY = "microlog.appender.FileAppender.File";
    public static final String FILE_APPENDER_APPEND_KEY = "microlog.appender.FileAppender.Append";
    public static final String LOG_LEVEL_PREFIX_KEY = "microlog.level";
    public static final String TAG_PREFIX_KEY = "microlog.tag";
    public static final String[] APPENDER_ALIASES = new String[]{"LogCatAppender", "FileAppender"};
    public static final String[] APPENDER_CLASS_NAMES = new String[]{"com.google.code.microlog4android.appender.LogCatAppender", "com.google.code.microlog4android.appender.FileAppender"};
    public static final String[] FORMATTER_ALIASES = new String[]{"SimpleFormatter", "PatternFormatter"};
    public static final String[] FORMATTER_CLASS_NAMES = new String[]{"com.google.code.microlog4android.format.SimpleFormatter", "com.google.code.microlog4android.format.PatternFormatter"};
    private static final HashMap<String, String> appenderAliases = new HashMap(43);
    private static final HashMap<String, String> formatterAliases = new HashMap(21);
    private Context context;
    private LoggerRepository loggerRepository;

    private PropertyConfigurator(Context context) {
        int index = 0;
        while (index < APPENDER_ALIASES.length) {
            appenderAliases.put(APPENDER_ALIASES[index], APPENDER_CLASS_NAMES[index]);
            ++index;
        }
        index = 0;
        while (index < FORMATTER_ALIASES.length) {
            formatterAliases.put(FORMATTER_ALIASES[index], FORMATTER_CLASS_NAMES[index]);
            ++index;
        }
        this.context = context;
        this.loggerRepository = DefaultLoggerRepository.INSTANCE;
    }

    public static PropertyConfigurator getConfigurator(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("The context must not be null");
        }
        return new PropertyConfigurator(context);
    }

    public void configure() {
        this.configure(DEFAULT_PROPERTIES_FILENAME);
    }

    public void configure(String filename) {
        Resources resources = this.context.getResources();
        AssetManager assetManager = resources.getAssets();
        try {
            InputStream inputStream = assetManager.open(filename);
            Properties properties = this.loadProperties(inputStream);
            this.startConfiguration(properties);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Failed to open the microlog properties file. Hint: the file should be in the /assets directory " + filename + " " + e));
        }
    }

    public void configure(int resId) {
        Resources resources = this.context.getResources();
        try {
            InputStream rawResource = resources.openRawResource(resId);
            Properties properties = this.loadProperties(rawResource);
            this.startConfiguration(properties);
        }
        catch (Resources.NotFoundException e) {
            Log.e((String)TAG, (String)("Did not find the microlog properties resource. Hint: this should be in the /res/raw directory " + (Object)((Object)e)));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Failed to read the microlog properties resource." + e));
        }
    }

    private Properties loadProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    private void startConfiguration(Properties properties) {
        if (properties.containsKey(ROOT_LOGGER_KEY)) {
            Log.i((String)TAG, (String)"Modern configuration not yet supported");
        } else {
            Log.i((String)TAG, (String)"Configure using the simple style (aka classic style)");
            this.configureSimpleStyle(properties);
        }
    }

    private void configureSimpleStyle(Properties properties) {
        this.setLevel(properties);
        String appenderString = properties.getProperty(APPENDER_PREFIX_KEY, "LogCatAppender");
        List<String> appenderList = this.parseAppenderString(appenderString);
        this.setAppenders(appenderList, properties);
        this.setFormatter(properties);
    }

    private void setLevel(Properties properties) {
        String levelString = (String)properties.get(LOG_LEVEL_PREFIX_KEY);
        Level level = this.stringToLevel(levelString);
        if (level != null) {
            this.loggerRepository.getRootLogger().setLevel(level);
            Log.i((String)TAG, (String)("Root level: " + (Object)((Object)this.loggerRepository.getRootLogger().getLevel())));
        }
    }

    private List<String> parseAppenderString(String appenderString) {
        StringTokenizer tokenizer = new StringTokenizer(appenderString, ";,");
        ArrayList<String> appenderList = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String appender = (String)tokenizer.nextElement();
            appenderList.add(appender);
        }
        return appenderList;
    }

    private void setAppenders(List<String> appenderList, Properties properties) {
        for (String string : appenderList) {
            this.addAppender(string, properties);
        }
    }

    private void addAppender(String string, Properties properties) {
        Logger rootLogger = this.loggerRepository.getRootLogger();
        String className = appenderAliases.get(string);
        if (className == null) {
            className = string;
        }
        try {
            Class<?> appenderClass = Class.forName(className);
            Appender appender = (Appender)appenderClass.newInstance();
            if (appender != null) {
                if (appender instanceof FileAppender) {
                    this.setPropertiesForFileAppender(appender, properties);
                }
                Log.i((String)TAG, (String)("Adding appender " + appender.getClass().getName()));
                rootLogger.addAppender(appender);
            }
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Failed to find appender class: " + e));
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("No access to appender class: " + e));
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)("Failed to instantiate appender class: " + e));
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)("Specified appender class does not implement the Appender interface: " + e));
        }
    }

    private void setPropertiesForFileAppender(Appender appender, Properties properties) {
        String fileName = properties.getProperty(FILE_APPENDER_FILE_NAME_KEY, "microlog.txt");
        ((FileAppender)appender).setFileName(fileName);
        String append_string = properties.getProperty(FILE_APPENDER_APPEND_KEY, "true");
        boolean append_bool = Boolean.parseBoolean(append_string);
        ((FileAppender)appender).setAppend(append_bool);
    }

    private void setFormatter(Properties properties) {
        String formatterString = properties.getProperty(FORMATTER_PREFIX_KEY, "PatternFormatter");
        String className = null;
        if (formatterString != null) {
            className = formatterAliases.get(formatterString);
        }
        if (className == null) {
            className = formatterString;
        }
        try {
            Class<?> formatterClass = Class.forName(className);
            Formatter formatter = (Formatter)formatterClass.newInstance();
            if (formatter instanceof PatternFormatter) {
                String pattern = properties.getProperty(PATTERN_LAYOUT_PREFIX_KEY, "%r %c{1} [%P] %m %T");
                ((PatternFormatter)formatter).setPattern(pattern);
            }
            if (formatter != null) {
                Logger rootLogger = this.loggerRepository.getRootLogger();
                int numberOfAppenders = rootLogger.getNumberOfAppenders();
                int appenderNo = 0;
                while (appenderNo < numberOfAppenders) {
                    Appender appender = rootLogger.getAppender(appenderNo);
                    appender.setFormatter(formatter);
                    ++appenderNo;
                }
            }
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Failed to find Formatter class: " + e));
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)("Failed to instantiate formtter: " + e));
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("No access to formatter class: " + e));
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)("Specified formatter class does not implement the Formatter interface: " + e));
        }
    }

    private Level stringToLevel(String levelString) {
        return Level.valueOf(levelString);
    }
}

