/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android.appender;

import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.appender.DatagramAppender;
import com.google.code.microlog4android.appender.SyslogMessage;

public class SyslogAppender
extends DatagramAppender {
    private SyslogMessage syslogMessage = new SyslogMessage();

    public SyslogAppender() {
        super.setPort(514);
        this.syslogMessage.setTag("microlog");
        this.syslogMessage.setFacility((byte)1);
        this.syslogMessage.setSeverity((byte)7);
    }

    @Override
    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            this.sendMessage(this.syslogMessage.createMessageData(this.formatter.format(clientID, name, time, level, message, t)));
        }
    }

    public void setFacility(byte facility) {
        this.syslogMessage.setFacility(facility);
    }

    public void setSeverity(byte severity) throws IllegalArgumentException {
        this.syslogMessage.setSeverity(severity);
    }

    public void setHeader(boolean header) {
        this.syslogMessage.setHeader(header);
    }

    public void setHostname(String hostname) throws IllegalArgumentException {
        this.syslogMessage.setHostname(hostname);
    }

    public void setTag(String tag) throws IllegalArgumentException {
        this.syslogMessage.setTag(tag);
    }
}

