/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android.appender;

import android.util.Log;
import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.appender.AbstractAppender;
import java.io.IOException;

public class LogCatAppender
extends AbstractAppender {
    @Override
    public void clear() {
    }

    @Override
    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            switch (level) {
                case FATAL: 
                case ERROR: {
                    Log.e((String)clientID, (String)this.formatter.format(clientID, name, time, level, message, t));
                    break;
                }
                case WARN: {
                    Log.w((String)clientID, (String)this.formatter.format(clientID, name, time, level, message, t));
                    break;
                }
                case INFO: {
                    Log.i((String)clientID, (String)this.formatter.format(clientID, name, time, level, message, t));
                    break;
                }
                case DEBUG: 
                case TRACE: {
                    Log.d((String)clientID, (String)this.formatter.format(clientID, name, time, level, message, t));
                    break;
                }
            }
        }
    }

    @Override
    public void open() throws IOException {
        this.logOpen = true;
    }

    @Override
    public void close() throws IOException {
        this.logOpen = false;
    }

    @Override
    public long getLogSize() {
        return -1L;
    }
}

