/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android.appender;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.appender.AbstractAppender;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class FileAppender
extends AbstractAppender {
    private static final String TAG = "Microlog.FileAppender";
    public static final String DEFAULT_FILENAME = "microlog.txt";
    private String fileName = "microlog.txt";
    private PrintWriter writer;
    private boolean append = false;
    private File mSdCardLogFile = null;
    Context mContext = null;

    public FileAppender(Context c) {
        this.mContext = c;
    }

    public FileAppender() {
    }

    @Override
    public synchronized void open() throws IOException {
        File logFile = this.getLogFile();
        this.logOpen = false;
        if (logFile != null) {
            FileOutputStream fileOutputStream;
            if (!logFile.exists() && !logFile.createNewFile()) {
                Log.e((String)TAG, (String)"Unable to create new log file");
            }
            if ((fileOutputStream = new FileOutputStream(logFile, this.append)) != null) {
                this.writer = new PrintWriter(fileOutputStream);
                this.logOpen = true;
            } else {
                Log.e((String)TAG, (String)"Failed to create the log file (no stream)");
            }
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void close() throws IOException {
        Log.i((String)TAG, (String)"Closing the FileAppender");
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public synchronized void doLog(String clientID, String name, long time, Level level, Object message, Throwable throwable) {
        if (this.logOpen && this.formatter != null && this.writer != null) {
            this.writer.println(this.formatter.format(clientID, name, time, level, message, throwable));
            this.writer.flush();
            if (throwable != null) {
                throwable.printStackTrace();
            }
        } else if (this.formatter == null) {
            Log.e((String)TAG, (String)"Please set a formatter.");
        }
    }

    @Override
    public long getLogSize() {
        return -1L;
    }

    public void setFileName(String fileName) {
        if (fileName != null) {
            this.fileName = fileName;
        }
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    protected synchronized File getExternalStorageDirectory() {
        File externalStorageDirectory = Environment.getExternalStorageDirectory();
        int sdk = new Integer(Build.VERSION.SDK);
        if (sdk >= 8 && this.mContext != null) {
            try {
                Method getExtFilesDir = Context.class.getMethod("getExternalFilesDir", String.class);
                externalStorageDirectory = (File)getExtFilesDir.invoke((Object)this.mContext, new Object[1]);
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Could not execute method getExternalFilesDir() on sdk >=8", (Throwable)t);
            }
        }
        if (externalStorageDirectory != null && !externalStorageDirectory.exists() && !externalStorageDirectory.mkdirs()) {
            externalStorageDirectory = null;
            Log.e((String)TAG, (String)("mkdirs failed on externalStorageDirectory " + externalStorageDirectory));
        }
        return externalStorageDirectory;
    }

    public synchronized File getLogFile() {
        if (this.mSdCardLogFile == null) {
            File externalStorageDirectory;
            String externalStorageState = Environment.getExternalStorageState();
            if (externalStorageState.equals("mounted") && (externalStorageDirectory = this.getExternalStorageDirectory()) != null) {
                this.mSdCardLogFile = new File(externalStorageDirectory, this.fileName);
            }
            if (this.mSdCardLogFile == null) {
                Log.e((String)TAG, (String)"Unable to open log file from external storage");
            }
        }
        return this.mSdCardLogFile;
    }
}

