/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android.appender;

import android.util.Log;
import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.appender.AbstractAppender;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class DatagramAppender
extends AbstractAppender {
    private static final String TAG = "Microlog.DatagramAppender";
    public static final String DEFAULT_HOST = "127.0.0.1";
    private DatagramSocket datagramSocket;
    private InetAddress address;
    private String host = "127.0.0.1";
    private int port;
    private DatagramPacket datagramPacket;

    @Override
    public void open() throws IOException {
        this.datagramSocket = new DatagramSocket();
        this.address = InetAddress.getByName(this.host);
        this.datagramPacket = new DatagramPacket(new byte[0], 0, this.address, this.port);
        this.logOpen = true;
    }

    @Override
    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            String logMessage = this.formatter.format(clientID, name, time, level, message, t);
            this.sendMessage(logMessage);
        }
    }

    public void sendMessage(String message) {
        byte[] datagramData = message.getBytes();
        this.datagramPacket.setData(datagramData);
        try {
            this.datagramSocket.send(this.datagramPacket);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Failed to send datagram log " + e));
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public void close() throws IOException {
        if (this.datagramSocket != null) {
            this.datagramSocket.close();
        }
        this.logOpen = false;
    }

    @Override
    public long getLogSize() {
        return -1L;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

